;=======================================
; Mode 2 + Mode 0 COLDATA Gradient
; Channels: Red, Green, Blue
; Table Size: 72
; No. of Writes: 224
; 
; Generated by GradientTool
;=======================================

; Set up the HDMA gradient.
; Uses HDMA channels 3 and 4.
init:
	REP   #$20 ; 16-bit A

	; Set transfer modes.
	LDA   #$3202
	STA   $4330 ; Channel 3
	LDA   #$3200
	STA   $4340 ; Channel 4

	; Point to HDMA tables.
	LDA   #Gradient1_RedGreenTable
	STA   $4332
	LDA   #Gradient1_BlueTable
	STA   $4342

	SEP   #$20 ; 8-bit A

	; Store program bank to $43x4.
	PHK
	PLA
	STA   $4334 ; Channel 3
	STA   $4344 ; Channel 4

	; Enable channels 3 and 4.
	LDA.b #%00011000
	TSB   $0D9F|!addr

	RTL ; <-- Can also be RTL.

; --- HDMA Tables below this line ---
Gradient1_RedGreenTable:
db $02,$35,$5A
db $02,$34,$5A
db $0E,$34,$59
db $03,$33,$59
db $0C,$33,$58
db $05,$32,$58
db $0A,$32,$57
db $07,$31,$57
db $08,$31,$56
db $09,$30,$56
db $07,$30,$55
db $0A,$2F,$55
db $05,$2F,$54
db $0C,$2E,$54
db $03,$2E,$53
db $0E,$2D,$53
db $02,$2D,$52
db $0F,$2C,$52
db $54,$2B,$51
db $00

Gradient1_BlueTable:
db $80,$9F
db $60,$9F
db $00
